const app = getApp()

Component({
  options: {
    multipleSlots: true
  },
  properties: {
    // 这里定义了innerText属性，属性值可以在组件使用时指定
    title: {  //标题
      type: String,
      value: '',
    },
    background: {  //背景颜色
      type: String,
      value: '#fff',
    },
    fontColor: { //标题字体颜色
      type: String,
      value: '#000'
    },
    showWhite: {
      type: Boolean,
      value: false
    },
    showArrow: { // 是否显示返回箭头
      type: Boolean,
      value: true
    },
    cusEvent: { // 是否自定义事件
      type: Boolean,
      value: false
    },
    hideBackHome: { // 隐藏左侧返回区域
      type: Boolean,
      value: false
    },
    showPlaceholder: { // 是否显示占位元素
      type: Boolean,
      value: true
    },
    subTitle: {
      type: String,
      value: ''
    },
    subFontColor: {
      type: String,
      value: '#FF3333'
    },
    cusSubStyle: {
      type: String,
      value: ''
    }
  },
  /**
   * 这里是一些组件内部数据
   */
  data: {
    statusBarHeight: 0,
    tabbarList: [
      'index/index'
    ]
  },

  attached: function () {
    this.setData({
      statusBarHeight: app.globalData.statusBarHeight
    })
    let router = getCurrentPages();
    let { route } = router[router.length - 1]
    let { tabbarList, hideBackHome } = this.data
    let isTab = tabbarList.includes(route)
    this.setData({
      hideBackHome: isTab || hideBackHome
    })
    if (router.length == 1) {
      this.setData({
        showArrow: false
      })
    }
  },

  methods: {
    // 这里是一个自定义方法
    onClickLeft () {
      if (this.data.cusEvent) {
        this.triggerEvent('onClickLeft', true)
        return
      }
      wx.navigateBack()
    },

    onClickHome () {
      wx.reLaunch({
        url: '/index/index'
      })
    }
  }
})
