const app = getApp()

Component({
  properties: {
    imgUrls: {
      type: Array,
      value: []
    },
    imgKey: {
      type: String,
      value: 'url'
    },
    showDots: {
      type: Boolean,
      value: true
    },
    swiperHeight: {
      type: Number,
      value: 368
    },
    autoplay: {
      type: Boolean,
      value: false
    },
    circular: {
      type: Boolean,
      value: true
    },
    interval: {
      type: Number,
      value: 5000
    },
    duration: {
      type: Number,
      value: 500
    }
  },
  /**
   * 这里是一些组件内部数据
   */
  data: {
    current: 0
  },

  methods: {
    // 轮播图滚动事件
    swiperChange(e) {
      let {
        current
      } = e.detail
      this.setData({
        current
      })
    },

    onTapItem(e) {
      let {
        item
      } = e.currentTarget.dataset
      this.triggerEvent('onTapItem', {
        item
      })
    }
  }
})